<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>HOJA DE RUTA</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
</head>
<style>
    tr,
    td,
    th {

        padding: 5px;
    }

    table {
        width: 100%;
    }

    body {
        font-size: 10px;
        background-image: url('{{ public_path('assets/temp/ugel2.png') }}');
        /* Ruta a tu imagen de fondo */
        background-size: contain;
        background-repeat: no-repeat;
        background-position: center;
    }

    .text-center {
        width: 8px
    }

    .red {
        background-color: #ea818d;
    }

    .day {
        background-color: #a2c0e1;
    }

    .hd {
        background-color: #00ACAC;
    }

    .hx {
        background-color: #1C75C7;
    }

    .hz {
        background-color: #F49B1A;
    }

    .hw {
        background-color: #8753DE;
    }

    .cab {
        background-color: transparent;

    }

    .hp {
        background-color: #003C5E;
    }

    #footer {
        position: fixed;
        bottom: 0cm;
    }

    .border_container {
        border: 1px solid black;
        border-radius: 20px;
    }
    .text-azul {
        color: #003C5E;
    }
</style>

<body class="">
    @php

        function convertir_mes($mes)
        {
            $meses = [
                '0',
                'ENERO',
                'FEBRERO',
                'MARZO',
                'ABRIL',
                'MAYO',
                'JUNIO',
                'JULIO',
                'AGOSTO',
                'SETIEMBRE',
                'OCTUBRE',
                'NOVIEMBRE',
                'DICIEMBRE',
            ];
            $mesFormateado = ltrim($mes, '0');
            return $meses[$mesFormateado];
        }
        function formatearFecha($fechaOriginal)
        {
            // Separar la fecha y la hora
            [$fecha, $hora] = explode(' ', $fechaOriginal);

            // Obtener partes de la fecha
            $partesFecha = explode('-', $fecha);
            $anio = $partesFecha[0];
            $mes = $partesFecha[1];
            $dia = $partesFecha[2];

            // Definir un arreglo con los nombres de los meses
            $meses = [
                'enero',
                'febrero',
                'marzo',
                'abril',
                'mayo',
                'junio',
                'julio',
                'agosto',
                'septiembre',
                'octubre',
                'noviembre',
                'diciembre',
            ];

            $mesFormateado = $meses[intval($mes) - 1]; // Restamos 1 para obtener el nombre del mes correcto

            // Formatear la hora
            [$horas, $minutos, $segundos] = explode(':', $hora);

            // Devolver la fecha y hora formateada
            return "$dia de $mesFormateado del $anio a las $horas:$minutos:$segundos";
        }
    @endphp
    <table class="mb-3">
        <tr>
            <td style="text-align: center;border-color: white;" class="p-0">
                <b style="font-size: 14px;">UNIDAD DE GESTION EDUCATIVA LOCAL YUNGUYO</b>
            </td>
        </tr>
        
        <tr>
            <td style="text-align: center;border-color: white;" class="p-0">
                <b style="font-size: 14px">HOJA DE RUTA</b>
            </td>
        </tr>
    </table>
    @php
        $partes = explode('-', $expediente['numero_expediente']);
    @endphp
    <div class="mb-3" style="border: 1px solid #000;border-radius:12px;padding:10px">
        <table class="mb-3" style="border-radius: 10px;">
            <tr class="hx">
                <td style="color: white;border: 1px solid #1C75C7;" colspan="2">
                    <b>DATOS DEL EXPEDIENTE PRINCIPAL</b>
                </td>
            </tr>
            @if (isset($partes[0]) && isset($partes[1]))
                <tr>
                    <td style="border: 1px solid #D3DADF;" class="cab"><b>NÚMERO DE EXPEDIENTE:</b>
                        {{ $partes[0] }}</td>
                    <td style="border: 1px solid #D3DADF;" class="cab"><b>AÑO:</b> {{ $partes[1] }}</td>
                </tr>
            @endif

            <tr>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>FECHA Y HORA:</b>
                    {{ date('d/m/Y H:i:s', strtotime($expediente['fecha_registro'])) }}</td>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>TIPO PERSONA:</b>
                    {{ strtoupper($expediente['tipo_persona']) }}</td>
            </tr>
            <tr>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>RUC:</b> {{ $expediente['ruc_remitente'] }}
                </td>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>RAZÓN SOCIAL:</b>
                    {{ $expediente['razon_remitente'] }}</td>
            </tr>
            <tr>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>DNI:</b> {{ $expediente['dni_remitente'] }}
                </td>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>REMITENTE:</b>
                    {{ $expediente['nombre_remitente'] }} {{ $expediente['paterno_remitente'] }}
                    {{ $expediente['materno_remitente'] }}</td>
            </tr>
            <tr>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>TELÉFONO:</b>
                    {{ $expediente['celular_remitente'] }}</td>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>CORREO:</b>
                    {{ $expediente['correo_remitente'] }}</td>
            </tr>
            <tr>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>TIPO DOCUMENTO:</b>
                    {{ $expediente['tipo_documento']['nombre'] }}</td>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>NRO DOCUMENTO:</b>
                    {{ $expediente['numero_documento'] }}</td>
            </tr>
            <tr>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>CABECERA:</b>
                    {{ $expediente['cabecera_documento'] }}</td>
                <td style="border: 1px solid #D3DADF;" class="cab"><b>FOLIOS :</b>
                    {{ $expediente['folios_documento'] }}</td>
            </tr>
            <tr>
                <td style="border: 1px solid #D3DADF;" colspan="2" class="cab"><b>ASUNTO:</b>
                    {{ $expediente['asunto_documento'] }}</td>
            </tr>
        </table>
    </div>
    <div class="mb-3" style="border: 1px solid #000;border-radius:12px;padding:10px">
        <table>
            <thead>
                <tr>
                    <th width="1%">#</th>
                    <th class="text-nowrap">Nro de Registro</th>
                    <th class="text-nowrap">Oficina</th>
                    <th class="text-nowrap">Responsable</th>
                    <th class="text-nowrap">Estado / Acción</th>
                    <th class="text-nowrap">Fecha</th>
                </tr>
            </thead>


            <tbody>
                @php
                    $cont = 1;
                @endphp
                @foreach ($data as $item)
                    <tr style="border: 1px solid #D3DADF;">
                        <td class="text-center">{{ $cont++ }}</td>
                        <td>{{ $item->ultimo_numero_registro ?: 'POR ASIGNAR' }}</td>
                        <td>{{ $item->oficina->nombre }} </td>
                        <td>{{ $item->empleado->nombre }} {{ $item->empleado->paterno }}
                            {{ $item->empleado->materno }} </td>
                        <td>{{ $item->estado }} </td>
                        <td>{{ $item->fecha_registro }} </td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <th width="1%">#</th>
                    <th class="text-nowrap">Nro de Registro</th>
                    <th class="text-nowrap">Oficina</th>
                    <th class="text-nowrap">Responsable</th>
                    <th class="text-nowrap">Estado / Acción</th>
                    <th class="text-nowrap">Fecha</th>
                </tr>
            </tfoot>


        </table>
        
    </div>
    <table class="mb-3">
        <tr>
            <td style="text-align: right;border: none;"><b class="text-azul">FECHA Y HORA DE CONSULTA: </b>
                {{ formatearFecha($fecha_actual) }}</td>
        </tr>
    </table>
    <div class="mb-3" style="border: 1px solid #000;border-radius:12px;padding:10px">
        <div>
            <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('assets/temp/qr.png'))) }}"
                alt="" width="80px">
            <div>
                Escaneando el código QR, podrá realizar el seguimiento de su trámite.
            </div>
        </div>
    </div>


    <table class=" mt-5">
        <tr>
            <td style="text-align:center;padding:20px;border: none;">
                <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('assets/temp/sgd.png'))) }}"
                    width="180px" alt="">
            </td>
        </tr>
    </table>








