<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>CARGO</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
</head>
<style>
    tr,
    td,
    th {

        padding: 6px;
    }

    table {


        width: 100%;
    }

    body {
        font-size: 11px;
        background-image: url('{{ public_path('assets/temp/ugel2.png') }}');
        /* Ruta a tu imagen de fondo */
        background-size: contain;
        background-repeat: no-repeat;
        background-position: center;

    }


    .text-center {
        width: 8px
    }

    .red {
        background-color: #ea818d;
    }

    .day {
        background-color: #a2c0e1;
    }

    .hd {
        background-color: #00ACAC;
    }

    .hx {
        background-color: #1C75C7;
    }

    .hz {
        background-color: #F49B1A;
    }

    .hw {
        background-color: #8753DE;
    }

    .cab {
        background-color: #D3DADF;

    }

    .hp {
        background-color: #003C5E;
    }

    #footer {
        position: fixed;
        bottom: 0cm;
    }

    .border_container {
        border: 1px solid black;
        border-radius: 20px;
    }

    .container_centrado {
        position: absolute;
        top: 62px;
        bottom: 0;
        left: 0;
        right: 0;
        display: table;
        width: 100%;
        height: 100%;
        text-align: center;

    }

    .content_centrado {
        display: table-cell;
        vertical-align: middle;
    }

    .box_centrado {
        border: 1px solid black;
        border-radius: 10px;
        width: 50%;
        padding: 2px;
        margin: 0 auto;
    }

    .text-azul {
        color: #003C5E;
    }
</style>

<body class="">

    @php

        function convertir_mes($mes)
        {
            $meses = [
                '0',
                'ENERO',
                'FEBRERO',
                'MARZO',
                'ABRIL',
                'MAYO',
                'JUNIO',
                'JULIO',
                'AGOSTO',
                'SETIEMBRE',
                'OCTUBRE',
                'NOVIEMBRE',
                'DICIEMBRE',
            ];
            $mesFormateado = ltrim($mes, '0');
            return $meses[$mesFormateado];
        }
        function formatearFecha($fechaOriginal)
        {
            // Separar la fecha y la hora
            [$fecha, $hora] = explode(' ', $fechaOriginal);

            // Obtener partes de la fecha
            $partesFecha = explode('-', $fecha);
            $anio = $partesFecha[0];
            $mes = $partesFecha[1];
            $dia = $partesFecha[2];

            // Definir un arreglo con los nombres de los meses
            $meses = [
                'enero',
                'febrero',
                'marzo',
                'abril',
                'mayo',
                'junio',
                'julio',
                'agosto',
                'septiembre',
                'octubre',
                'noviembre',
                'diciembre',
            ];

            $mesFormateado = $meses[intval($mes) - 1]; // Restamos 1 para obtener el nombre del mes correcto

            // Formatear la hora
            [$horas, $minutos, $segundos] = explode(':', $hora);

            // Devolver la fecha y hora formateada
            return "$dia de $mesFormateado del $anio a las $horas:$minutos:$segundos";
        }

    @endphp
    <table class="mb-3">
        <tr>
            <td style="text-align: center;border-color: white;" class="p-0">
                <b style="font-size: 14px;">UNIDAD DE GESTION EDUCATIVA LOCAL YUNGUYO</b>
            </td>
        </tr>
        <tr>
            <td style="text-align: center;border-color: white;" class="p-0">
                <b style="font-size: 14px">OFICINA DE TRAMITE DOCUMENTARIO</b>
            </td>
        </tr>
        <tr>
            <td style="text-align: center;border-color: white;" class="p-0">
                <b style="font-size: 14px">MESA DE PARTES VIRTUAL</b>
            </td>
        </tr>
    </table>
    <table class="mb-3">
        <tr>
            <td style="border: 1px solid white;font-size:12px;"> CÓDIGO UNICO DE TRAMITE - CUT:
                <b>{{ $expediente['numero_registro'] }}</b>
            </td>
        </tr>
    </table>
    <div class="mb-3" style="border: 1px solid #000;border-radius:12px;padding:10px">
        <table class="mb-3" style="border-radius: 10px;">
            <tr>
                <td style="border:none;text-align:center;" colspan="4">
                    <b style="font-size: 12px;color:#BB271B;">DATOS DEL SOLICITANTE</b>
                </td>
            </tr>

            <tr>
                <td style="border-bottom: 1px solid #D3DADF;" colspan="4"><b class="text-azul">TIPO DE PERSONA:</b>
                    {{ strtoupper( $expediente['tipo_persona'] ) }}</td>
            </tr>
            <tr>
                <td style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">DNI: <br></b> {{  $expediente['dni_remitente'] }}
                </td>
                <td style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">NOMBRE: <br></b> {{  $expediente['nombre_remitente']  }}
                </td>
                <td style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">APELLIDO PATERNO: <br>
                    </b>{{  $expediente['paterno_remitente']  }}
                </td>
                <td style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">APELLIDO MATERNO:
                        <br></b>{{ $expediente['materno_remitente']  }}
                </td>
            </tr>
            <tr>
                <td colspan="1" style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">RUC: <br>
                    </b>{{  $expediente['ruc_remitente']  }}</td>
                <td colspan="3" style="border-bottom: 1px solid #D3DADF;"> <b class="text-azul">RAZON SOCIAL:
                        <br></b>{{  $expediente['razon_remitente']  }}</td>
            </tr>
            <tr>
                <td colspan="1" style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">CORREO ELECTRÓNICO:
                        <br></b>{{  $expediente['correo_remitente'] }}</td>
                <td colspan="1" style="border-bottom: 1px solid #D3DADF;"> <b class="text-azul">TELÉFONO/CELULAR:
                        <br>
                    </b>{{  $expediente['celular_remitente'] }}</td>
                <td colspan="2" style="border-bottom: 1px solid #D3DADF;"> <b class="text-azul">DIRECCIÓN: <br>
                    </b>{{ $expediente['direccion_remitente']  }}</td>
            </tr>

        </table>

    </div>
    <div class="mb-3" style="border: 1px solid #000;border-radius:12px;padding:10px">
        <table class="mb-3" style="border-radius: 10px;">
            <tr>
                <td style="border:none;text-align:center;" colspan="3">
                    <b style="font-size: 12px;color:#BB271B;">DATOS DEL DOCUMENTO</b>
                </td>
            </tr>

            <tr>
                <td style="border-bottom: 1px solid #D3DADF;" colspan="3"><b class="text-azul">ASUNTO: <br></b>
                    <p class=" w-100 text-justify m-0 ">{{  $expediente['asunto_documento']  }}</p>
                </td>
            </tr>
            <tr>
                <td style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">TIPO DE DOCUMENTO: <br></b>
                    {{ $expediente['tipo_documento']['nombre'] }}
                </td>
                <td style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">NÚMERO DE DOCUMENTO: <br></b>
                    {{ $expediente['numero_documento'] }}</td>
                <td style="border-bottom: 1px solid #D3DADF;"><b class="text-azul">FOLIOS DEL DOCUMENTO: <br>
                    </b>{{  $expediente['folios_documento']  }}</td>
            </tr>
            <tr>
                <td style="border-bottom: 1px solid #D3DADF;" colspan="3"><b class="text-azul">CABECERA DEL
                        DOCUMENTO:
                        <br></b>{{  $expediente['cabecera_documento']  }}</td>
            </tr>
        </table>

    </div>
    <table class="mb-3">
        <tr>
            <td style="text-align: right;border: none;"><b class="text-azul">FECHA Y HORA DE REGISTRO: </b>
                {{ formatearFecha($fecha_actual) }}</td>
        </tr>
    </table>
    <div class="mb-5" style="border: 1px solid #000;border-radius:12px;padding:10px">
        <div>
            <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('assets/temp/qr.png'))) }}"
                alt="" width="80px">
            <div>
                Escaneando el código QR, podrá realizar el seguimiento de su trámite, utilizando el CUT
                generado.
            </div>
        </div>
    </div>
    <table class=" mt-5">
        <tr>
            <td style="text-align:center;padding:20px;border: none;">
                <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('assets/temp/sgd.png'))) }}"
                    width="180px" alt="">
            </td>
        </tr>
    </table>

</body>

</html>
