@extends('layouts.app')
@section('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap-5-theme.min.css') }}" />
    <style>
        .select2-selection__arrow {
            display: none !important;
        }
    </style>
@endsection
@section('content')
    <!-- begin breadcrumb -->
    <ol class="breadcrumb float-xl-right">
        <li class="breadcrumb-item"><a href="javascript:;">SGD</a></li>
        <li class="breadcrumb-item"><a href="javascript:;">Expedientes virtuales</a></li>
        <li class="breadcrumb-item active">Por recibir</li>
    </ol>
    <!-- end breadcrumb -->
    <!-- begin page-header -->
    <h1 class="page-header">Lista de expedientes virtuales externos</small></h1>
    <!-- end page-header -->
    <!-- begin row -->

    <div class="row">

        <!-- begin col-10 -->
        <div class="col-xl-12">
            <!-- begin panel -->
            <div class="panel panel-inverse">
                <!-- begin panel-heading -->
                <div class="panel-heading">
                    <h4 class="panel-title">Lista de expedientes virtuales externos</h4>

                </div>
                <!-- end panel-heading -->

                <!-- begin panel-body -->
                <div class="panel-body">
                    
                    <table id="tabla_expedientes" class="w-100 table table-striped table-bordered table-td-valign-middle">
                        <thead>
                            <tr>
                                <th width="1%">#</th>
                                <th class="text-nowrap">Tipo de persona</th>
                                <th style="width: 89px" class="text-nowrap">Mas datos</th>
                                <th class="text-nowrap">Tipo de documento</th>
                                <th class="text-nowrap">Asunto</th>
                                <th class="text-nowrap">Fecha registro</th>
                                <th class="text-nowrap">Estado</th>
                                <th class="text-nowrap">Acciones</th>
                            </tr>
                        </thead>

                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th width="1%">#</th>
                                <th class="text-nowrap">Tipo de persona</th>
                                <th class="text-nowrap">Mas datos</th>
                                <th class="text-nowrap">Tipo de documento</th>
                                <th class="text-nowrap">Asunto</th>
                                <th class="text-nowrap">Fecha registro</th>
                                <th class="text-nowrap">Estado</th>
                                <th class="text-nowrap">Acciones</th>
                            </tr>
                        </tfoot>

                    </table>
                </div>
                <!-- end panel-body -->
            </div>
            <!-- end panel -->
        </div>
        <!-- end col-10 -->
    </div>
    >

    <!-- end row -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_atender_expediente">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Atender expediente virtual</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 mb-3">
                            <div class="alert alert-success fade show d-none">
                                <span class="close" data-dismiss="alert">×</span>
                                Último número de expediente asignado: <strong><span id="fin_exp"></span></strong>
                            </div>
                            <label>Asignar un número de expediente <span class=" text-danger">*</span> </label>
                            <div class="row row-space-10">
                                <div class="col-md-6 m-b-3">
                                    <input  type="text" id="numero_expediente" class="form-control" placeholder="Número"
                                        required="">
                                </div>
                                <div class="col-md-6 m-b-3">
                                    <input type="text" value="{{ date('Y') }}" class="form-control" disabled>
                                </div>
                                <input type="text" id="id_edit" hidden>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="customCheck1">
                                <label class="custom-control-label" for="customCheck1">Generar número automáticamente</label>
                              </div>
                        </div>

                    </div>
                    
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                    <a href="javascript:;" id="atender" class="btn btn-success">Aceptar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_remitente">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del remitente</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de persona <span class="text-danger"></span></label>
                            <div class="input-group">
                                <input id="tipo_persona" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>RUC<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="ruc" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Razón social<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="razon" type="text" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6 mb-3">
                            <label>Documento de identidad<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="dni" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Nombres<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="nombre" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido paterno<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="paterno" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Apellido materno<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="materno" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-12 mb-3">
                            <label>Dirección<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="direccion" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Correo electrónico<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="correo" type="text" class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-6 mb-3">
                            <label>Teléfono / Celular<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input disabled id="celular" type="text" class="form-control">
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->

    <!-- #modal-dialog -->
    <div class="modal fade" id="modal_datos_documento">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Datos del documento</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <label class="control-label">Tipo de documento <span class="text-danger"></span></label>
                            <div class="input-group">
                                <input id="tipo_documento" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Numero<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="numero_documento" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-2 mb-3">
                            <label>Folios<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="folios_documento" type="text" class="form-control" disabled>
                            </div>
                        </div>
                        <div class="col-lg-4 mb-3">
                            <label>Cabecera<span class=" text-danger"></span> </label>
                            <div class="input-group">
                                <input id="cabecera_documento" type="text" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">

                            <iframe id="documento_doc" width="100%" height="500" src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
     <!-- #modal-dialog -->
     <div class="modal fade" id="modal_ver_cargo">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Cargo de registro</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-sm-12">

                            <iframe id="documento_doc_cargo_or" width="100%" height="500"
                                src=""></iframe>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-white" data-dismiss="modal">Cerrar</a>
                </div>
            </div>
        </div>
    </div>
    <!-- #modal-dialog -->
@endsection
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('js/bandeja-buzon.js') }}"></script>
    <script>
        $('#anio').select2({
            dropdownParent: '#modal_atender_expediente',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });
        $('#rol').select2({
            dropdownParent: '#modal_registrar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            placeholder: 'Seleccionar',
            language: {
                noResults: function() {
                    return 'No se encontraron resultados';
                }
            }
        });

        $('#empleado_edit').select2({
            dropdownParent: '#modal_editar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        });
        $('#rol_edit').select2({
            dropdownParent: '#modal_editar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        });
        $('#oficina_edit').select2({
            dropdownParent: '#modal_editar',
            theme: "bootstrap-5",
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        });
    </script>
@endsection
